/*
 * Decompiled with CFR 0.152.
 */
package panther.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import panther.test.Bootstrappable;

public class TestClassLoading
extends ClassLoader {
    protected List<JarFile> jarFiles = new ArrayList<JarFile>();
    protected Map<String, JarEntry> index = new HashMap<String, JarEntry>();
    protected Map<JarEntry, JarFile> fileIndex = new HashMap<JarEntry, JarFile>();

    protected Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray = this.loadClassData(string);
        System.out.println("<" + string + ">");
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    protected byte[] loadClassData(String string) throws ClassNotFoundException {
        JarEntry jarEntry = this.index.get(string);
        if (jarEntry == null) {
            throw new ClassNotFoundException("Unknown class: <" + string + ">");
        }
        try {
            int n = (int)jarEntry.getSize();
            byte[] byArray = new byte[n];
            JarFile jarFile = this.fileIndex.get(jarEntry);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n2 = inputStream.read(byArray, 0, n);
            inputStream.close();
            return byArray;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new ClassNotFoundException("Unable to load class <" + string + "> due to following error", throwable);
        }
    }

    public void addJar(JarFile jarFile) throws Exception {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (!string.endsWith(".class")) continue;
            String string2 = string.replace(".class", "");
            if (this.index.containsKey(string2 = string2.replace("/", "."))) continue;
            this.index.put(string2, jarEntry);
            this.fileIndex.put(jarEntry, jarFile);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        JarFile jarFile = new JarFile(stringArray[0]);
        TestClassLoading testClassLoading = new TestClassLoading();
        testClassLoading.addJar(jarFile);
        Class<?> clazz = testClassLoading.loadClass("plibbasic.util.Bootstrap");
        System.out.println("newClass = " + clazz);
        Object obj = clazz.newInstance();
        System.out.println("instance = " + obj);
        Bootstrappable bootstrappable = (Bootstrappable)obj;
        bootstrappable.bootstrap();
    }
}

